package com.yee.test.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.junit.Test;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.yee.product.util.HttpUtil;
import com.yee.product.util.SignUtil;
import com.yee.test.bean.InvoiceGoodsBean;
import com.yee.test.bean.Order;

public class InvoiceTest {

	private static final String OPEN_URL = CustomerTest.OPEN_URL;

	/**
	 * 电子发票下单 使用电子发票前请使用商户手机号登录微信公众号配置商品
	 * 
	 * @throws JsonProcessingException
	 */
	@Test
	public void electronicOrderTest() throws JsonProcessingException {
		String url = OPEN_URL + "/invoice/electronic/order";

		Order order = new Order();
		order.setBillAmount("20");
		order.setType("2");
		order.setBillingCode(CustomerTest.BILLING_CODE);
		order.setOrderNo(Long.toString(System.currentTimeMillis()));

		List<InvoiceGoodsBean> invoiceGoods = new ArrayList<InvoiceGoodsBean>();
		InvoiceGoodsBean e = new InvoiceGoodsBean();
		e.setGoodsNum("1");
		e.setGoodsNo("7002901");
		invoiceGoods.add(e);

		e = new InvoiceGoodsBean();
		e.setGoodsNo("7002902");
		e.setTaxAmount("2");
		invoiceGoods.add(e);
		order.setInvoiceGoods(invoiceGoods);

		ObjectMapper objectMapper = new ObjectMapper();
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", CustomerTest.ACCESS_KEY);
		param.put("order", objectMapper.writeValueAsString(order));
		String makeStringSign = SignUtil.md5Sign(param, CustomerTest.KEY_APPEND + CustomerTest.MD5_KEY, CustomerTest.SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, CustomerTest.defaultRequestConfig);

	}

	
	/**
	 * 查询电子发票开票明细
     */
	@Test
	public void electronicRecordQueryTest() {
		String url = OPEN_URL + "/invoice/electronic/query";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", CustomerTest.ACCESS_KEY);
		param.put("billingCode", CustomerTest.BILLING_CODE);
		param.put("billRecordNo", "11669767718981475191");
		String makeStringSign = SignUtil.md5Sign(param, CustomerTest.KEY_APPEND + CustomerTest.MD5_KEY, CustomerTest.SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, CustomerTest.defaultRequestConfig);
	}
}
