package com.yee.test.service;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.client.config.RequestConfig;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.yee.product.util.HttpUtil;
import com.yee.product.util.SignUtil;

public class CustomerTest {

	protected static final Logger logger = LoggerFactory.getLogger(CustomerTest.class);

	public static RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(5000).setConnectionRequestTimeout(5000).build();

	public static final String OPEN_URL = "https://top.yeepiao.com";

	public static final String ACCESS_KEY = "a38ca4b74f06eebf235e3996c6a392af";
	public static final String MD5_KEY = "1b03741f22d747d2accaeb8ecadba5a7";

	public static final String KEY_APPEND = "&key=";
	public static final String SIGN_IGNORES = "sign";

	/**
	 * 测试注册前请修改开票码参数
	 */
	public static final String BILLING_CODE = "30012346";

	/**
	 * 商户注册
	 */
	@Test
	public void registTest() {
		String url = OPEN_URL + "/customer/regist";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", ACCESS_KEY);
		param.put("billingCode", BILLING_CODE);
		param.put("enterpriseName", "易票科技");
		param.put("taxNo", "123456789012345");
		param.put("linkMan", "易票科技");
		param.put("phoneNo", "18301310627");

		String makeStringSign = SignUtil.md5Sign(param, KEY_APPEND + MD5_KEY, SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, defaultRequestConfig);
	}

	/**
	 * 商户信息修改
	 */
	@Test
	public void updateTest() {
		String url = OPEN_URL + "/customer/update";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", ACCESS_KEY);
		param.put("billingCode", BILLING_CODE);
		param.put("enterpriseName", "易票科技");
		param.put("taxNo", "339901999999142");
		param.put("linkMan", "易票科技");
		String makeStringSign = SignUtil.md5Sign(param, KEY_APPEND + MD5_KEY, SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, defaultRequestConfig);
	}

	/**
	 * 扫企业二维码名片开票
	 */
	@Test
	public void cardBillTest() {
		String url = OPEN_URL + "/invoice/card/bill";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", ACCESS_KEY);
		param.put("billingCode", BILLING_CODE);
		param.put(
				"cardData",
				"$015LmQ5a+M5pSv5LuY5pyJ6ZmQ5YWs5Y+4PC8+OTE1MzAwMDA1NzcyOTU0ODAyPC8+5LqR5Y2X55yB5piG5piO5biC57uP5rWO5oqA5pyv5byA5Y+R5Yy657uP5byA6LevM+WPt+enkeaKgOWIm+aWsOWbrUIyLTMw5Y+3MDg3MS02ODMzMDQxNDwvPuS4iua1t+a1puS4nOWPkeWxlemTtuihjOaYhuaYjua7h+axoOi3r+aUr+ihjCA3ODE3MDE1NDgwMDAwMDAxMTwvPkIwQTU=$");
		String makeStringSign = SignUtil.md5Sign(param, KEY_APPEND + MD5_KEY, SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, defaultRequestConfig);
	}

	/**
	 * 商户信息查询
	 */
	@Test
	public void customerQueryTest() {
		String url = OPEN_URL + "/customer/query";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", ACCESS_KEY);
		param.put("billingCode", BILLING_CODE);
		String makeStringSign = SignUtil.md5Sign(param, KEY_APPEND + MD5_KEY, SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, defaultRequestConfig);
	}

	/**
	 * 查询电子发票商品信息
	 * 使用电子发票前请商户使用手机号登录微信公众号配置商品
	 */
	@Test
	public void goodsQueryTest() {
		String url = OPEN_URL + "/customer/query/goods";
		Map<String, String> param = new HashMap<String, String>();
		param.put("accessKey", ACCESS_KEY);
		param.put("billingCode", BILLING_CODE);
		String makeStringSign = SignUtil.md5Sign(param, KEY_APPEND + MD5_KEY, SIGN_IGNORES);
		param.put("sign", makeStringSign);
		HttpUtil.post(url, null, param, defaultRequestConfig);
	}


}
