package com.yee.product.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;

import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.yee.product.exception.HttpException;

public class HttpUtil {
	private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
	private static final String HTTP = "http";
	private static final String HTTPS = "https";
	private static final String UTF_8 = "UTF-8";
	private static SSLConnectionSocketFactory sslsf = null;
	private static PoolingHttpClientConnectionManager cm = null;
	private static SSLContextBuilder builder = null;
	private static CloseableHttpClient httpClient = null;

	static {
		try {
			builder = new SSLContextBuilder();
			builder.loadTrustMaterial(null, new TrustStrategy() {
				@Override
				public boolean isTrusted(X509Certificate[] x509Certificates, String s)
						throws CertificateException {
					return true;
				}
			});
			sslsf = new SSLConnectionSocketFactory(builder.build(), new HostnameVerifier() {
				@Override
				public boolean verify(String s, SSLSession sslSession) {
					return true;
				}
			});
			Registry<ConnectionSocketFactory> registry = RegistryBuilder
					.<ConnectionSocketFactory> create()
					.register(HTTP, new PlainConnectionSocketFactory()).register(HTTPS, sslsf)
					.build();
			cm = new PoolingHttpClientConnectionManager(registry);
			cm.setMaxTotal(200);
			cm.setDefaultMaxPerRoute(cm.getMaxTotal());
			HttpClientBuilder httpClientBuilder = HttpClients.custom();
			httpClientBuilder.setSSLSocketFactory(sslsf);

			RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(3000)
					.setConnectTimeout(2000).setConnectionRequestTimeout(2000).build();
			httpClientBuilder.setDefaultRequestConfig(defaultRequestConfig);
			httpClientBuilder.setRetryHandler(new DefaultHttpRequestRetryHandler(0, false));
			httpClient = httpClientBuilder.setConnectionManager(cm)
					.setConnectionManagerShared(true).build();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
		}
	}

	public static String post(String url) {
		return post(url, null, null, null);
	}

	public static String get(String url) {
		return get(url, null, null, null);
	}

	public static String get(String url, Map<String, String> header, Map<String, String> param) {
		return get(url, header, param, null);
	}

	public static String post(String url, Map<String, String> header, Map<String, String> param) {
		return post(url, header, param, null);
	}

	public static String post(String url, RequestConfig config) {
		return post(url, null, null, null);
	}

	public static String get(String url, RequestConfig config) {
		return get(url, null, null, config);
	}

	public static String postJson(String url, Object params, RequestConfig config) {
		return postJson(url, null, params, config);
	}

	public static String postJson(String url, Map<String, String> header, Object params,
			RequestConfig config) {
		RequestBuilder requestBuilder = RequestBuilder.post(url);
		if (params != null) {
			StringEntity entity = new StringEntity(JSONObject.toJSONString(params), Consts.UTF_8);
			entity.setContentEncoding(UTF_8);
			entity.setContentType("application/json");
			requestBuilder.setEntity(entity);
		}
		return httpRequest(requestBuilder, header, config);
	}

	public static String post(String url, Map<String, String> header, Map<String, String> param,
			RequestConfig config) {
		RequestBuilder requestBuilder = RequestBuilder.post(url);
		try {
			ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
			if (!CollectionUtils.isEmpty(param)) {
				param.forEach((key, value) -> {
					list.add(new BasicNameValuePair(key, value));
				});
			}
			requestBuilder.setEntity(new UrlEncodedFormEntity(list, UTF_8));
		} catch (UnsupportedEncodingException e) {
			throw new RuntimeException(e);
		}

		return httpRequest(requestBuilder, header, config);
	}

	public static String get(String url, Map<String, String> header, Map<String, String> param,
			RequestConfig config) {
		// 如果有参数，生成并拼接在url后
		if (!CollectionUtils.isEmpty(param)) {
			ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
			param.forEach((key, value) -> {
				list.add(new BasicNameValuePair(key, value));
			});

			try {
				String paramStr = EntityUtils
						.toString(new UrlEncodedFormEntity(list, Consts.UTF_8));
				url = url + "?" + paramStr;
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
		}

		RequestBuilder requestBuilder = RequestBuilder.get(url);
		return httpRequest(requestBuilder, header, config);
	}

	public static String httpRequest(RequestBuilder requestBuilder, Map<String, String> header,
			RequestConfig config) {
		logger.info("requestBuilder:{}, header:{}", requestBuilder, header);

		if (!CollectionUtils.isEmpty(header)) {
			header.forEach((key, value) -> {
				if (StringUtils.hasText(key)) {
					requestBuilder.addHeader(key, value);
				}
			});
		}

		if (config != null) {
			requestBuilder.setConfig(config);
		}
		HttpUriRequest request = requestBuilder.build();
		logger.info("Executing request {}", request.getRequestLine());
		Header[] allHeaders = request.getAllHeaders();
		for (Header h : allHeaders) {
			logger.info("Executing request {}: {}", h.getName(), h.getValue());
		}

		ResponseHandler<String> responseHandler = new ResponseHandler<String>() {
			@Override
			public String handleResponse(final HttpResponse response)
					throws ClientProtocolException, IOException {

				HttpEntity entity = response.getEntity();
				String responseEntity = entity != null ? EntityUtils.toString(entity, Consts.UTF_8) : null;

				logger.info("handleResponse: {}, responseEntity={}", response, responseEntity);

				int status = response.getStatusLine().getStatusCode();
				if (status >= 200 && status < 300) {
					return responseEntity;
				} else {
					throw new HttpResponseException(status, "Unexpected response status: " + status);
				}
			}
		};

		try {
			String responseBody = httpClient.execute(request, responseHandler);
			logger.info("httpclient.execute responseBody: {}", responseBody);
			return responseBody;
		} catch (HttpResponseException e) {
			throw new HttpException(e);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
}
